[![npm version](https://badge.fury.io/js/litepicker.svg)](https://www.npmjs.com/package/litepicker) [![Build Status](https://travis-ci.org/wakirin/Litepicker.svg?branch=master)](https://travis-ci.org/wakirin/Litepicker) [![license](https://img.shields.io/github/license/mashape/apistatus.svg)](https://github.com/wakirin/Litepicker/blob/master/README.md)

Litepicker
=========

Date range picker - lightweight, no dependencies

## Features
* No dependencies
* Single date or date range
* Show multiple months
* Min/Max days for select and/or Min/Max dates for select
* Select forward/backward
* Inline mode
* Repick date range
* Lock days  
* Keyboard accessibility (with plugin)
* Mobile friendly (with plugin)
* Predefined ranges (with plugin)
* Multiple select (with plugin)
  
See more details in docs.

# [Documentation](https://litepicker.com)

## Compatibility

##### Desktop
- IE 11 (required [polyfills](https://github.com/wakirin/litepicker-polyfills-ie11))
- Edge 17+
- Chrome 60+
- Firefox 52+
- Safari 10.1+
- Opera 48+

##### Mobile
- iOS 10+
  - Safari
  - Chrome
- Android 7+
  - Chrome
  - Firefox
  - Samsung Browser
  - UC Browser

## Plugins
* [keyboardnav](https://litepicker.com/docs/plugins/keyboardnav/) - adds keyboard navigation.
* [mobilefriendly](https://litepicker.com/docs/plugins/mobilefriendly/) - adds swipes (left/right) to switch months.
* [ranges](https://litepicker.com/docs/plugins/ranges/) - adds predefined ranges.
* [multiselect](https://litepicker.com/docs/plugins/multiselect/) - adds multiple selection.

## See also:
* [Drupal module](https://www.drupal.org/project/date_range_picker) by [kviolka](https://github.com/kviolka)
* [Wordpress Ninja forms](https://github.com/soderlind/date-range-ninja-forms) by [soderlind](https://github.com/soderlind)
* [ember-litepicker](https://github.com/sinankeskin/ember-litepicker) by [sinankeskin](https://github.com/sinankeskin)

## Supporting Litepicker
[![](https://github.com/wakirin/Litepicker/blob/gh-pages/assets/images/coffee.png?raw=true)](https://ko-fi.com/wakirin)

## Tested on real browsers
Tested on real browsers via BrowserStack.  
Thanks to the BrowserStack for supporting the open-source projects.  

[![](https://github.com/wakirin/Litepicker/blob/gh-pages/assets/images/Browserstack-logo.png?raw=true)](https://www.browserstack.com/)